// JavaInterface.cpp

#include <jni.h>

#include "mdName.h"

extern "C" JNIEXPORT jlong JNICALL Java_mdName_mdName_mdCreate(JNIEnv* /*Env_*/,
		jclass /*Class_*/) {
	return (jlong) (new mdName());
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdDestroy(JNIEnv* /*Env_*/,
		jclass /*Class_*/,jlong I_) {
	delete (mdName*) I_;
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetPathToNameFiles(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Path_) {
	char *Path;

	Path=(char*) Env_->GetStringUTFChars(Path_,0);
	((mdName*) I_)->SetPathToNameFiles(Path);
	Env_->ReleaseStringUTFChars(Path_,Path);
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdInitializeDataFiles(
		JNIEnv* /*Env_*/,jclass /*Class_*/,jlong I_) {
	return ((mdName*) I_)->InitializeDataFiles();
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetInitializeErrorString(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetInitializeErrorString());
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdSetLicenseString(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring License_) {
	char *License;
	int RetVal;

	License=(char*) Env_->GetStringUTFChars(License_,0);
	RetVal=((mdName*) I_)->SetLicenseString(License);
	Env_->ReleaseStringUTFChars(License_,License);
	return RetVal;
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetBuildNumber(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetBuildNumber());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetDatabaseDate(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetDatabaseDate());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetDatabaseExpirationDate(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetDatabaseExpirationDate());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetLicenseExpirationDate(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetLicenseExpirationDate());
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdSetPrimaryNameHint(
		JNIEnv* /*Env_*/,jclass /*Class_*/,jlong I_,jint NameHint_) {
	return ((mdName*) I_)->SetPrimaryNameHint((mdName::NameHints) NameHint_);
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdSetSecondaryNameHint(
		JNIEnv* /*Env_*/,jclass /*Class_*/,jlong I_,jint NameHint_) {
	return ((mdName*) I_)->SetSecondaryNameHint((mdName::NameHints) NameHint_);
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdSetFirstNameSpellingCorrection(
		JNIEnv* /*Env_*/,jclass /*Class_*/,jlong I_,jint Status_) {
	return ((mdName*) I_)->SetFirstNameSpellingCorrection(Status_!=0);
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdSetGenderPopulation(
		JNIEnv* /*Env_*/,jclass /*Class_*/,jlong I_,jint Population_) {
	return ((mdName*) I_)->SetGenderPopulation((mdName::Population) Population_);
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdSetGenderAggression(
		JNIEnv* /*Env_*/,jclass /*Class_*/,jlong I_,jint Aggression_) {
	return ((mdName*) I_)->SetGenderAggression((mdName::Aggression) Aggression_);
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdAddSalutation(
		JNIEnv* /*Env_*/,jclass /*Class_*/,jlong I_,jint Salutation_) {
	return ((mdName*) I_)->AddSalutation((mdName::Salutations) Salutation_);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetSalutationPrefix(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Prefix_) {
	char *Prefix;

	Prefix=(char*) Env_->GetStringUTFChars(Prefix_,0);
	((mdName*) I_)->SetSalutationPrefix(Prefix);
	Env_->ReleaseStringUTFChars(Prefix_,Prefix);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetSalutationSuffix(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Suffix_) {
	char *Suffix;

	Suffix=(char*) Env_->GetStringUTFChars(Suffix_,0);
	((mdName*) I_)->SetSalutationSuffix(Suffix);
	Env_->ReleaseStringUTFChars(Suffix_,Suffix);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetSalutationSlug(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Slug_) {
	char *Slug;

	Slug=(char*) Env_->GetStringUTFChars(Slug_,0);
	((mdName*) I_)->SetSalutationSlug(Slug);
	Env_->ReleaseStringUTFChars(Slug_,Slug);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdClearProperties(
		JNIEnv* /*Env_*/,jclass /*Class_*/,jlong I_) {
	((mdName*) I_)->ClearProperties();
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetFullName(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Name_) {
	char *Name;

	Name=(char*) Env_->GetStringUTFChars(Name_,0);
	((mdName*) I_)->SetFullName(Name);
	Env_->ReleaseStringUTFChars(Name_,Name);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetPrefix(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Prefix_) {
	char *Prefix;

	Prefix=(char*) Env_->GetStringUTFChars(Prefix_,0);
	((mdName*) I_)->SetPrefix(Prefix);
	Env_->ReleaseStringUTFChars(Prefix_,Prefix);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetPrefix2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Prefix_) {
	char *Prefix;

	Prefix=(char*) Env_->GetStringUTFChars(Prefix_,0);
	((mdName*) I_)->SetPrefix2(Prefix);
	Env_->ReleaseStringUTFChars(Prefix_,Prefix);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetFirstName(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring First_) {
	char *First;

	First=(char*) Env_->GetStringUTFChars(First_,0);
	((mdName*) I_)->SetFirstName(First);
	Env_->ReleaseStringUTFChars(First_,First);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetFirstName2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring First_) {
	char *First;

	First=(char*) Env_->GetStringUTFChars(First_,0);
	((mdName*) I_)->SetFirstName2(First);
	Env_->ReleaseStringUTFChars(First_,First);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetMiddleName(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Middle_) {
	char *Middle;

	Middle=(char*) Env_->GetStringUTFChars(Middle_,0);
	((mdName*) I_)->SetMiddleName(Middle);
	Env_->ReleaseStringUTFChars(Middle_,Middle);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetMiddleName2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Middle_) {
	char *Middle;

	Middle=(char*) Env_->GetStringUTFChars(Middle_,0);
	((mdName*) I_)->SetMiddleName2(Middle);
	Env_->ReleaseStringUTFChars(Middle_,Middle);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetLastName(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Last_) {
	char *Last;

	Last=(char*) Env_->GetStringUTFChars(Last_,0);
	((mdName*) I_)->SetLastName(Last);
	Env_->ReleaseStringUTFChars(Last_,Last);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetLastName2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Last_) {
	char *Last;

	Last=(char*) Env_->GetStringUTFChars(Last_,0);
	((mdName*) I_)->SetLastName2(Last);
	Env_->ReleaseStringUTFChars(Last_,Last);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetSuffix(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Suffix_) {
	char *Suffix;

	Suffix=(char*) Env_->GetStringUTFChars(Suffix_,0);
	((mdName*) I_)->SetSuffix(Suffix);
	Env_->ReleaseStringUTFChars(Suffix_,Suffix);
}

extern "C" JNIEXPORT void JNICALL Java_mdName_mdName_mdSetSuffix2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_,jstring Suffix_) {
	char *Suffix;

	Suffix=(char*) Env_->GetStringUTFChars(Suffix_,0);
	((mdName*) I_)->SetSuffix2(Suffix);
	Env_->ReleaseStringUTFChars(Suffix_,Suffix);
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdParse(JNIEnv* /*Env_*/,
		jclass /*Class_*/,jlong I_) {
	return ((mdName*) I_)->Parse();
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdGenderize(JNIEnv* /*Env_*/,
		jclass /*Class_*/,jlong I_) {
	return ((mdName*) I_)->Genderize();
}

extern "C" JNIEXPORT jint JNICALL Java_mdName_mdName_mdSalutate(JNIEnv* /*Env_*/,
		jclass /*Class_*/,jlong I_) {
	return ((mdName*) I_)->Salutate();
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetStatusCode(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
		return Env_->NewStringUTF(((mdName*) I_)->GetStatusCode());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetErrorCode(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetErrorCode());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetChangeCode(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetChangeCode());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetPrefix(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetPrefix());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetPrefix2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetPrefix2());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetFirstName(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetFirstName());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetFirstName2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetFirstName2());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetMiddleName(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetMiddleName());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetMiddleName2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetMiddleName2());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetLastName(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetLastName());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetLastName2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetLastName2());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetSuffix(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetSuffix());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetSuffix2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetSuffix2());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetGender(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetGender());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetGender2(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetGender2());
}

extern "C" JNIEXPORT jstring JNICALL Java_mdName_mdName_mdGetSalutation(
		JNIEnv *Env_,jclass /*Class_*/,jlong I_) {
	return Env_->NewStringUTF(((mdName*) I_)->GetSalutation());
}
